using System;

public class Fraction
{
	private int numerator;
	private int denominator;

	// Tworzy uamek na podstawie 
	// podanego licznika i mianownika
	public Fraction(int numerator, int denominator)
	{
		this.numerator = numerator;
		this.denominator = denominator;
	}

	// Przeciony operator + przyjmuje dwa uamki
	// i zwraca ich sum
	public static Fraction operator +(Fraction lhs, Fraction rhs)
	{
		// Uamki o wsplnym mianowniku mona dodawa
		// dodajc ich liczniki
		if (lhs.denominator == rhs.denominator)
		{
			return new Fraction(lhs.numerator + rhs.numerator,
			lhs.denominator);
		}

		// Uproszczone rozwizania dla uamkw o rnych mianownikach
		// 1/2 + 3/4 == (1*4) + (3*2) / (2*4) == 10/8.
		// Ta technika nie przeprowadza redukcji
		int firstProduct = lhs.numerator * rhs.denominator;
		int secondProduct = rhs.numerator * lhs.denominator;
		return new Fraction(
		   firstProduct + secondProduct,
		   lhs.denominator * rhs.denominator
		   );
	}

	// Zwraca acuchow reprezentacj uamka
	public override string ToString()
	{
		String s = numerator.ToString() + "/" +
		denominator.ToString();
		return s;
	}
}


public class Tester
{
	public void Run()
	{
		Fraction firstFraction = new Fraction(3, 4);
		Console.WriteLine("firstFraction: {0}", firstFraction.ToString());

		Fraction secondFraction = new Fraction(2, 4);
		Console.WriteLine("secondFraction: {0}", secondFraction.ToString());

		Fraction sumOfTwoFractions = firstFraction + secondFraction;
		Console.WriteLine(
		   "firstFraction + secondFraction = sumOfTwoFractions: {0}",
		   sumOfTwoFractions.ToString());
	}

	static void Main()
	{
		Tester t = new Tester();
		t.Run();
	}
}
